/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.service.managedsystem.LockingException;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.SD;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SetLock
implements Effector {
    private static final String TRACE_MASKT = "XRVXSLKT";
    private static final String TRACE_MASKF = "XRVXSLKF";
    private static final String TRACE_MASKD = "XRVXSLKD";

    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> SetLock.fire");
        try {
            Map userData = context.getUserData();
            List fruList = (List)userData.get("SELECTED_FRUS");
            if (fruList != null) {
                Iterator it = fruList.iterator();
                ArrayList<ServiceableElement> locked = new ArrayList<ServiceableElement>(fruList.size());
                boolean error = false;
                while (it.hasNext() && !error) {
                    ServiceableElement se = (ServiceableElement)it.next();
                    try {
                        se.setServiceLock(userData);
                        locked.add(se);
                    }
                    catch (LockingException le) {
                        error = true;
                        if (locked.size() <= 0) continue;
                        Iterator lockedIt = locked.iterator();
                        while (lockedIt.hasNext()) {
                            ServiceableElement toUnlock = (ServiceableElement)lockedIt.next();
                            try {
                                toUnlock.resetServiceLock(userData);
                            }
                            catch (LockingException ule) {
                                Trace.trace(TRACE_MASKF, "SetLock.fire, in exception path, unable to unlock held lock on element[" + toUnlock + "]???");
                                Trace.trace(TRACE_MASKT, ule);
                            }
                        }
                    }
                }
                if (!error) {
                    context.getVariable(SD.LOCK_STATUS_VARIABLE).setValue(SD.LOCKED);
                } else {
                    context.getVariable(SD.LOCK_STATUS_VARIABLE).setValue(SD.FAILED);
                }
                Trace.trace(TRACE_MASKT, "<- SetLock.fire");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! SetLock.fire, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
    }
}

